function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Cartel_w_inv_shocks.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(76, 146);
g1(1,28)=T(34)+T(37);
g1(1,31)=T(34);
g1(1,11)=T(36);
g1(1,45)=exp(y(28))*exp(y(31))*T(86);
g1(1,46)=T(122);
g1(1,49)=T(123);
g1(1,64)=exp(y(28));
g1(1,21)=T(260);
g1(1,23)=T(35)*(-(exp(y(28))*T(26)));
g1(1,89)=(-1);
g1(1,132)=params(30);
g1(2,29)=T(28)*(-T(22))+T(22)*y(68)+y(78)*(-(T(33)*params(4)*params(4)*exp(y(29)*params(4))));
g1(2,45)=(-T(22))*T(86);
g1(2,46)=T(125);
g1(2,52)=T(126);
g1(2,68)=T(22);
g1(2,78)=(-(T(33)*params(4)*exp(y(29)*params(4))));
g1(2,91)=(-1);
g1(2,134)=params(30);
g1(3,30)=y(77)*(-(T(31)*params(4)*params(4)*exp(y(30)*params(4))))+T(38)+y(73)*y(41)*T(31)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(3,41)=y(73)*T(31)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(3,51)=T(38);
g1(3,68)=T(21);
g1(3,73)=y(41)*T(31)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(3,77)=(-(T(31)*params(4)*exp(y(30)*params(4))));
g1(3,90)=(-1);
g1(3,133)=params(30);
g1(4,28)=T(34);
g1(4,31)=T(28)*T(41)+y(81)*(-exp(y(31)))+exp(y(31))*y(80);
g1(4,45)=T(41)*T(86);
g1(4,46)=T(41)*T(99);
g1(4,54)=T(28)*(-T(40));
g1(4,61)=T(113);
g1(4,62)=T(115);
g1(4,80)=exp(y(31));
g1(4,81)=(-exp(y(31)));
g1(4,93)=(-1);
g1(4,136)=params(30);
g1(5,32)=y(81)*(-exp(y(32)))+exp(y(32))*y(79);
g1(5,79)=exp(y(32));
g1(5,81)=(-exp(y(32)));
g1(5,92)=(-1);
g1(5,135)=params(30);
g1(6,33)=T(44);
g1(6,37)=T(51);
g1(6,113)=T(42);
g1(6,114)=T(257);
g1(6,119)=params(30)*exp(y(33))*params(6)*exp(y(113))*exp(params(5)*(y(37)-y(114)));
g1(6,76)=exp(y(33));
g1(6,122)=params(30)*(-(exp(y(33))*(1-exp((-y(114)))*exp(y(37)))));
g1(6,126)=T(264);
g1(7,34)=T(46);
g1(7,38)=T(128);
g1(7,119)=params(30)*exp(y(34))*params(6)*exp(params(5)*y(38));
g1(7,75)=exp(y(34));
g1(7,121)=params(30)*(-((1-exp(y(38)))*exp(y(34))));
g1(7,125)=params(30)*(-(exp(y(38))*exp(y(34))));
g1(8,35)=T(47);
g1(8,76)=(-(params(7)*exp(y(35))));
g1(8,78)=exp(y(35));
g1(8,124)=params(30)*(-((1-params(7))*exp(y(35))));
g1(9,36)=T(48);
g1(9,75)=(-(params(7)*exp(y(36))));
g1(9,77)=exp(y(36));
g1(9,123)=params(30)*(-((1-params(7))*exp(y(36))));
g1(10,33)=T(51);
g1(10,37)=params(30)*y(131)*(-exp(y(37)))+T(132);
g1(10,113)=T(49);
g1(10,114)=T(258);
g1(10,119)=T(259);
g1(10,122)=T(263);
g1(10,126)=T(264);
g1(10,131)=params(30)*(-exp(y(37)));
g1(11,103)=y(71)*T(124);
g1(11,34)=T(128);
g1(11,38)=T(45)+T(56)+T(137)+T(139)+params(30)*y(119)*exp(y(34))*params(6)*params(5)*params(5)*exp(params(5)*y(38));
g1(11,104)=y(71)*(-(exp(y(111))*(-exp(y(38)))));
g1(11,111)=T(53)+T(55);
g1(11,113)=T(245);
g1(11,119)=params(30)*exp(y(34))*params(6)*params(5)*exp(params(5)*y(38));
g1(11,71)=T(54);
g1(11,74)=T(52);
g1(11,121)=params(30)*(-(exp(y(34))*(-exp(y(38)))));
g1(11,125)=params(30)*(-(exp(y(38))*exp(y(34))));
g1(12,39)=exp(y(39))*y(67);
g1(12,67)=exp(y(39));
g1(13,11)=T(35)*y(21)*(-(T(26)*(-exp(y(11)))));
g1(13,49)=T(140);
g1(13,21)=T(35)*(-(T(26)*(1-exp(y(11)))));
g1(13,71)=1;
g1(13,72)=(-params(7));
g1(13,23)=T(26)*T(35);
g1(14,30)=y(73)*T(31)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(14,49)=T(35)*y(22)*(-(T(26)*(1-params(7))));
g1(14,22)=T(35)*(-(T(26)*(1-params(7))));
g1(14,72)=1;
g1(14,73)=params(4)*exp(y(30)*(params(4)-1))*T(31);
g1(15,42)=T(8)*y(81)+y(64)*(-(params(11)*T(12)*T(143)))+y(63)*(-(T(59)*T(147)+params(11)*T(58)*params(11)*T(58)*T(148)));
g1(15,43)=y(64)*(-(T(57)*params(11)*T(60)));
g1(15,13)=y(63)*(-(params(11)*T(58)*T(148)*T(163)));
g1(15,45)=y(63)*(-(params(11)*T(58)*T(96)*T(148)));
g1(15,50)=y(63)*(-(params(11)*T(58)*T(108)*T(148)));
g1(15,63)=(-(params(11)*T(58)*T(59)));
g1(15,64)=(-(params(11)*T(12)*T(57)));
g1(15,81)=T(8);
g1(16,42)=y(64)*(-(T(57)*params(11)*T(60)));
g1(16,43)=y(68)*(-exp(y(43)))+y(66)*(-(T(5)*T(19)*T(16)*exp(T(1)*y(50))*(1-params(11))*params(3)*T(153)))+y(65)*(-(T(17)*T(3)*T(16)*exp(T(1)*y(50))*(1-params(11))*(1-params(3))*T(153)))+exp(y(43))*y(63)+y(64)*(-(T(14)*params(11)*T(153)));
g1(16,13)=y(66)*T(165)+y(65)*(-(T(17)*T(166)));
g1(16,45)=T(154);
g1(16,50)=T(157);
g1(16,63)=exp(y(43));
g1(16,64)=(-(T(14)*params(11)*T(60)));
g1(16,65)=(-(T(17)*T(3)*T(16)*T(62)));
g1(16,66)=(-(T(5)*T(19)*T(16)*T(61)));
g1(16,68)=(-exp(y(43)));
g1(16,94)=(-1);
g1(16,137)=params(30);
g1(17,106)=params(30)*y(115)*(-(T(69)*params(11)*T(149)*T(150)));
g1(17,107)=params(30)*y(116)*(-(T(73)*(T(65)*T(76)*T(159)+T(66)*T(78)*T(159))))+params(30)*y(117)*T(160);
g1(17,44)=T(20)*y(68)+params(30)*y(119)*(-(T(20)*(1-params(10))))+params(30)*y(115)*(-(T(72)*T(179)+T(69)*T(69)*T(150)))+params(30)*y(116)*(-(T(73)*(T(75)*T(76)*T(177)+T(65)*T(75)*T(78)+T(65)*T(75)*T(78)+T(66)*T(75)*T(181))))+params(30)*y(117)*(-(T(64)*(T(78)*T(80)*T(81)+T(79)*T(80)*T(181)+T(78)*T(80)*T(81)+T(76)*T(80)*T(184))))+params(30)*y(118)*(-(exp((1-params(3))*y(108))*exp(T(1)*y(112))*params(3)*params(3)*exp(params(3)*y(44))));
g1(17,108)=params(30)*y(115)*(-(T(72)*T(218)+T(69)*T(150)*T(63)*T(68)*T(66)*T(217)))+params(30)*y(116)*(-((T(65)*T(75)*T(76)+T(66)*T(75)*T(78))*T(219)+T(73)*(T(65)*T(75)*T(77)*T(66)*T(217)+T(66)*T(75)*T(220))))+params(30)*y(117)*(-((T(79)*T(78)*T(80)+T(76)*T(80)*T(81))*T(217)+T(64)*(T(79)*T(80)*T(220)+T(81)*T(80)*T(77)*T(66)*T(217))))+params(30)*y(118)*(-(exp(T(1)*y(112))*params(3)*exp(params(3)*y(44))*(1-params(3))*exp((1-params(3))*y(108))));
g1(17,112)=params(30)*y(115)*(-(T(72)*T(241)+T(69)*T(150)*T(70)*(1-params(11))*T(1)*exp(T(1)*y(112))))+params(30)*y(116)*(-(T(73)*T(243)))+params(30)*y(117)*(-(T(64)*T(244)))+params(30)*y(118)*(-(exp((1-params(3))*y(108))*params(3)*exp(params(3)*y(44))*T(1)*exp(T(1)*y(112))));
g1(17,115)=params(30)*(-(T(69)*T(72)));
g1(17,116)=params(30)*(-(T(73)*(T(65)*T(75)*T(76)+T(66)*T(75)*T(78))));
g1(17,117)=params(30)*T(82);
g1(17,118)=params(30)*(-(exp((1-params(3))*y(108))*exp(T(1)*y(112))*params(3)*exp(params(3)*y(44))));
g1(17,68)=T(20);
g1(17,119)=params(30)*(-(T(20)*(1-params(10))));
g1(18,28)=exp(y(28))*exp(y(31))*T(86);
g1(18,29)=(-T(22))*T(86);
g1(18,31)=T(41)*T(86);
g1(18,42)=y(63)*(-(T(96)*params(11)*T(58)*T(148)));
g1(18,43)=T(154);
g1(18,13)=y(67)*(-(T(87)*exp(T(1)*y(50))*params(3)*exp(y(13)*params(3))))+y(66)*(-(T(89)*(T(19)*T(18)*T(90)*T(162)+T(16)*T(18)*T(164))+T(5)*(T(18)*T(91)*T(164)+T(19)*T(18)*T(168))))+y(65)*(-(T(17)*(T(15)*T(91)*T(161)+T(3)*T(15)*T(168))+T(93)*T(169)))+y(63)*(-(T(96)*T(148)*T(163)+T(59)*T(171)));
g1(18,14)=y(70)*T(189);
g1(18,45)=(T(41)-T(22))*T(196)+y(70)*(-(params(1)*T(196)/T(30)))+T(4)*y(69)+y(67)*(-(exp(T(1)*y(50))*exp(y(13)*params(3))*(1-params(3))*T(87)))+y(66)*T(201)+y(65)*T(205)+y(63)*(-(T(96)*T(96)*T(148)+T(59)*T(206)))+params(30)*y(120)*T(208);
g1(18,108)=params(30)*y(120)*(-((-(T(86)*T(224)))/(T(28)*T(28))));
g1(18,15)=y(70)*T(225);
g1(18,46)=(T(41)-T(22))*T(227)+y(70)*(-(params(1)*T(227)/T(30)))+params(30)*y(120)*T(229);
g1(18,109)=params(30)*y(120)*(-((-(T(86)*params(1)*exp(y(109))*T(223)))/(T(28)*T(28))));
g1(18,50)=y(67)*(-(T(87)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))))+T(212)+T(213)+y(63)*(-(T(59)*T(214)+T(96)*T(108)*T(148)));
g1(18,52)=(-T(22))*T(86);
g1(18,54)=T(86)*(-T(40));
g1(18,61)=T(215);
g1(18,62)=T(216);
g1(18,63)=(-(T(59)*T(96)));
g1(18,65)=T(94);
g1(18,66)=T(92);
g1(18,67)=T(88);
g1(18,69)=T(4);
g1(18,70)=(-(params(1)*T(86)/T(30)));
g1(18,120)=params(30)*(-((-(T(86)*T(98)))/(T(28)*T(28))));
g1(19,28)=T(122);
g1(19,29)=T(125);
g1(19,31)=T(41)*T(99);
g1(19,14)=y(70)*T(190);
g1(19,45)=(T(41)-T(22))*T(209)+y(70)*(-(params(1)*T(209)/T(30)))+params(30)*y(120)*(-(T(210)/T(207)));
g1(19,108)=params(30)*y(120)*(-((-(T(99)*T(224)))/(T(28)*T(28))));
g1(19,15)=y(70)*T(226);
g1(19,46)=(T(41)-T(22))*T(230)+y(70)*(-(params(1)*T(230)/T(30)))+exp(y(46))*y(68)+params(30)*y(120)*(-((T(28)*T(28)*(-(T(98)*T(230)))-(-(T(98)*T(99)))*T(228))/T(207)));
g1(19,109)=params(30)*y(120)*(-((-(T(99)*params(1)*exp(y(109))*T(223)))/(T(28)*T(28))));
g1(19,52)=T(125);
g1(19,54)=T(99)*(-T(40));
g1(19,61)=T(231);
g1(19,62)=T(232);
g1(19,68)=exp(y(46));
g1(19,70)=T(100);
g1(19,120)=params(30)*(-((-(T(98)*T(99)))/(T(28)*T(28))));
g1(20,47)=exp(y(47))*y(66)+T(101);
g1(20,49)=T(101);
g1(20,66)=exp(y(47));
g1(20,20)=T(35)*(-(exp(y(47))*T(26)));
g1(21,48)=exp(y(48))*y(65)+y(69)*(-(T(24)*T(235)));
g1(21,65)=exp(y(48));
g1(21,69)=(-(T(24)*T(102)));
g1(22,28)=T(123);
g1(22,11)=T(134);
g1(22,40)=T(140);
g1(22,41)=T(35)*y(22)*(-(T(26)*(1-params(7))));
g1(22,47)=T(101);
g1(22,49)=T(104);
g1(22,53)=T(236);
g1(22,20)=T(35)*(-(T(26)*(1+exp(y(47))-params(10))));
g1(22,70)=T(26);
g1(22,21)=T(35)*T(103);
g1(22,22)=T(35)*(-(y(41)*T(26)*(1-params(7))));
g1(22,23)=T(35)*(T(26)*params(6)*params(5)*exp(y(53))*exp(y(11)*(params(5)-1))-T(26)*(exp(y(28))-y(40)));
g1(23,42)=y(63)*(-(T(108)*params(11)*T(58)*T(148)));
g1(23,43)=T(157);
g1(23,13)=y(67)*T(172)+y(66)*(-(T(5)*T(173)))+y(65)*(-(T(17)*T(174)))+y(63)*(-(T(108)*T(148)*T(163)+T(59)*T(107)*T(95)*T(162)));
g1(23,45)=y(67)*(-(T(87)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))))+T(212)+T(213)+y(63)*(-(T(108)*T(96)*T(148)+T(59)*T(214)));
g1(23,50)=y(67)*T(238)+y(66)*(-(T(5)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(50))))+y(65)*T(239)+y(63)*(-(T(108)*T(108)*T(148)+T(59)*T(240)));
g1(23,63)=(-(T(59)*T(108)));
g1(23,65)=(-(T(17)*T(3)*T(16)*T(106)));
g1(23,66)=(-(T(5)*T(19)*T(16)*T(105)));
g1(23,67)=(-(exp(y(45)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))));
g1(23,83)=1;
g1(23,127)=params(30)*(-params(15));
g1(23,138)=T(109)*(-params(16));
g1(24,30)=T(38);
g1(24,51)=T(38)+y(73)*(-exp(y(51)));
g1(24,68)=T(21);
g1(24,73)=(-exp(y(51)));
g1(24,84)=1;
g1(24,128)=params(30)*(-params(18));
g1(24,139)=T(109)*(-params(19));
g1(25,29)=T(126);
g1(25,45)=(-T(22))*T(86);
g1(25,46)=T(125);
g1(25,52)=T(126);
g1(25,68)=T(22);
g1(25,85)=1;
g1(25,129)=params(30)*(-params(21));
g1(25,140)=T(109)*(-params(22));
g1(26,6)=T(23)*y(68);
g1(26,10)=y(68)*T(129);
g1(26,11)=T(135);
g1(26,49)=T(236);
g1(26,53)=T(110);
g1(26,62)=T(119);
g1(26,68)=T(23);
g1(26,21)=T(261);
g1(26,23)=T(262);
g1(26,86)=1;
g1(26,130)=params(30)*(-params(24));
g1(26,141)=T(109)*(-params(25));
g1(27,31)=T(28)*(-T(40));
g1(27,45)=T(86)*(-T(40));
g1(27,46)=T(99)*(-T(40));
g1(27,54)=T(28)*(-T(40));
g1(27,61)=T(113);
g1(27,62)=T(115);
g1(27,87)=1;
g1(28,89)=1;
g1(29,90)=1;
g1(30,91)=1;
g1(31,92)=1;
g1(32,93)=1;
g1(33,94)=1;
g1(34,31)=T(113);
g1(34,45)=T(215);
g1(34,46)=T(231);
g1(34,54)=T(113);
g1(34,61)=exp(y(61))*y(88)+T(248);
g1(34,62)=T(251);
g1(34,88)=exp(y(61));
g1(35,31)=T(115);
g1(35,6)=T(120);
g1(35,10)=T(130);
g1(35,45)=T(216);
g1(35,46)=T(232);
g1(35,53)=T(119);
g1(35,54)=T(115);
g1(35,61)=T(249);
g1(35,62)=T(253)+T(256);
g1(35,68)=T(118);
g1(35,76)=T(117);
g1(35,80)=T(116);
g1(35,82)=1;
g1(36,42)=(-(params(11)*T(58)*T(59)));
g1(36,43)=exp(y(43));
g1(36,13)=(-(T(59)*T(163)));
g1(36,45)=(-(T(59)*T(96)));
g1(36,50)=(-(T(59)*T(108)));
g1(37,28)=exp(y(28));
g1(37,42)=(-(params(11)*T(12)*T(57)));
g1(37,43)=(-(T(14)*params(11)*T(60)));
g1(38,43)=(-(T(17)*T(3)*T(16)*T(62)));
g1(38,13)=(-(T(17)*T(169)));
g1(38,45)=T(94);
g1(38,48)=exp(y(48));
g1(38,50)=(-(T(17)*T(3)*T(16)*T(106)));
g1(39,43)=(-(T(5)*T(19)*T(16)*T(61)));
g1(39,13)=(-(T(5)*(T(19)*T(18)*T(90)*T(162)+T(16)*T(18)*T(164))));
g1(39,45)=T(92);
g1(39,47)=exp(y(47));
g1(39,50)=(-(T(5)*T(19)*T(16)*T(105)));
g1(40,39)=exp(y(39));
g1(40,13)=(-(exp(y(45)*(1-params(3)))*exp(T(1)*y(50))*params(3)*exp(y(13)*params(3))));
g1(40,45)=T(88);
g1(40,50)=(-(exp(y(45)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))));
g1(41,29)=T(22);
g1(41,30)=T(21);
g1(41,6)=T(23);
g1(41,7)=exp(y(7))*params(6)*exp(params(5)*y(11));
g1(41,10)=T(129);
g1(41,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
g1(41,43)=(-exp(y(43)));
g1(41,13)=(-(exp(y(13))*(1-params(10))));
g1(41,44)=T(20);
g1(41,46)=exp(y(46));
g1(41,51)=T(21);
g1(41,52)=T(22);
g1(41,53)=T(23);
g1(41,62)=T(118);
g1(42,45)=T(4);
g1(42,48)=(-(T(24)*T(102)));
g1(43,110)=(-(exp(y(111))*exp(y(110))));
g1(43,111)=(-(exp(y(111))*(1+exp(y(110))-params(10))));
g1(44,14)=(-((-(params(1)*T(28)*T(188)))/(T(30)*T(30))));
g1(44,45)=(-(params(1)*T(86)/T(30)));
g1(44,15)=(-((-(params(1)*T(28)*exp(y(15))*T(187)))/(T(30)*T(30))));
g1(44,46)=T(100);
g1(44,49)=T(26);
g1(45,103)=T(124);
g1(45,38)=T(54);
g1(45,40)=1;
g1(45,104)=(-(exp(y(111))*(1-exp(y(38)))));
g1(45,111)=T(237);
g1(45,113)=(-(exp(y(111))*(-(params(6)*exp(y(113))*exp(params(5)*y(38))))));
g1(46,40)=(-params(7));
g1(46,41)=1;
g1(46,105)=(-(exp(y(111))*(1-params(7))));
g1(46,111)=(-(exp(y(111))*(1-params(7))*y(105)));
g1(47,30)=y(41)*T(31)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1));
g1(47,41)=params(4)*exp(y(30)*(params(4)-1))*T(31);
g1(47,51)=(-exp(y(51)));
g1(48,103)=(-(exp(y(111))*exp(y(103))));
g1(48,38)=T(52);
g1(48,104)=exp(y(111));
g1(48,111)=T(121);
g1(48,113)=T(32);
g1(49,7)=(-(exp(y(7))*(1-exp(y(11)))));
g1(49,34)=exp(y(34));
g1(49,36)=(-(params(7)*exp(y(36))));
g1(49,11)=(-(exp(y(7))*(-exp(y(11)))));
g1(50,6)=(-(exp(y(6))*(1-exp((-y(62)))*exp(y(10)))));
g1(50,33)=exp(y(33));
g1(50,35)=(-(params(7)*exp(y(35))));
g1(50,10)=T(131);
g1(50,62)=T(117);
g1(51,30)=(-(T(31)*params(4)*exp(y(30)*params(4))));
g1(51,9)=(-((1-params(7))*exp(y(9))));
g1(51,36)=exp(y(36));
g1(52,29)=(-(T(33)*params(4)*exp(y(29)*params(4))));
g1(52,8)=(-((1-params(7))*exp(y(8))));
g1(52,35)=exp(y(35));
g1(53,32)=exp(y(32));
g1(53,7)=(-(exp(y(7))*exp(y(11))));
g1(53,11)=(-(exp(y(7))*exp(y(11))));
g1(54,31)=exp(y(31));
g1(54,6)=T(127);
g1(54,10)=T(127);
g1(54,62)=T(116);
g1(55,31)=(-exp(y(31)));
g1(55,32)=(-exp(y(32)));
g1(55,42)=T(8);
g1(56,62)=1;
g1(56,144)=(-1);
g1(57,16)=(-params(15));
g1(57,50)=1;
g1(57,146)=(-1);
g1(57,24)=(-params(16));
g1(58,17)=(-params(18));
g1(58,51)=1;
g1(58,143)=(-1);
g1(58,25)=(-params(19));
g1(59,18)=(-params(21));
g1(59,52)=1;
g1(59,142)=(-1);
g1(59,26)=(-params(22));
g1(60,19)=(-params(24));
g1(60,53)=1;
g1(60,145)=(-1);
g1(60,27)=(-params(25));
g1(61,54)=1;
g1(62,10)=(-exp(y(10)));
g1(62,61)=exp(y(61));
g1(63,1)=1;
g1(63,28)=(-1);
g1(63,55)=1;
g1(64,3)=1;
g1(64,30)=(-1);
g1(64,56)=1;
g1(65,2)=1;
g1(65,29)=(-1);
g1(65,57)=1;
g1(66,5)=1;
g1(66,32)=(-1);
g1(66,58)=1;
g1(67,4)=1;
g1(67,31)=(-1);
g1(67,59)=1;
g1(68,12)=1;
g1(68,43)=(-1);
g1(68,60)=1;
g1(69,127)=(-1);
g1(69,95)=1;
g1(70,128)=(-1);
g1(70,96)=1;
g1(71,129)=(-1);
g1(71,97)=1;
g1(72,130)=(-1);
g1(72,98)=1;
g1(73,16)=(-1);
g1(73,99)=1;
g1(74,17)=(-1);
g1(74,100)=1;
g1(75,18)=(-1);
g1(75,101)=1;
g1(76,19)=(-1);
g1(76,102)=1;

end
